using System;
using System.Collections.Generic;
using System.Linq;

namespace CommissionExample
{
    class CommissionMember
    {
        public int Complaints { get; set; }
    }

    class Program
    {
        static void Main(string[] args)
        {
            int N = int.Parse(Console.ReadLine());
            List<CommissionMember> members = Console.ReadLine().Split().Select(x => new CommissionMember { Complaints = int.Parse(x) }).ToList();
            List<int> kapacitet = Console.ReadLine().Split().Select(int.Parse).ToList();

            int Q = int.Parse(Console.ReadLine());

            for (int i = 0; i < Q; i++)
            {
                int[] query = Console.ReadLine().Split().Select(int.Parse).ToArray();
                int k = query[0] - 1; 
                int x = query[1];

                ProcessQuery(members, kapacitet, k, x);
            }

            Console.WriteLine(string.Join(" ", members.Select(m => m.Complaints)));
        }

        static void ProcessQuery(List<CommissionMember> members, List<int> kapacitet, int k, int x)
        {
            while (k < members.Count && x > 0)
            {
                int spaceLeft = kapacitet[k] - members[k].Complaints;
                int addToKontejner = Math.Min(spaceLeft, x);

                members[k].Complaints += addToKontejner;
                x -= addToKontejner;

                if (members[k].Complaints == kapacitet[k])
                {
                    k++;
                }
            }
        }
    }
}